
import com.ducret.resultJ.ImProcessor;
import ij.*;
import ij.process.*;
import ij.gui.*;
import java.awt.*;
import ij.plugin.filter.*;
import ij.plugin.frame.Recorder;
import ij.measure.ResultsTable;
import static ij.plugin.filter.PlugInFilter.DOES_16;
import static ij.plugin.filter.PlugInFilter.DOES_32;
import static ij.plugin.filter.PlugInFilter.DOES_8G;
import static ij.plugin.filter.PlugInFilter.STACK_REQUIRED;

//Plugin to equalize stack of image
public class BackgroundCorrection_ implements PlugInFilter {

    ImagePlus imp;
    //ImageProcessor ref;
    //ImageStack stack;
    //int width, height;
    //int refChannel, refPosition, refSlice, refFrame;
    //boolean frameStack;
    private static final String[] channels = new String[]{"current", "all"};

    @Override
    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return DOES_8G + DOES_16 + DOES_32;
    }

    @Override
    public void run(ImageProcessor ip) {
        //width = imp.getWidth();
        //height = imp.getHeight();
        //stack = imp.getStack();

        int nbChannels = imp.getNChannels();
        int nbSlices = imp.getNSlices();
        int nbFrames = imp.getNFrames();

        int refChannel = imp.getC();
        int method, statMode, position, channel;


        channel = (int) Prefs.get("MicrobeJ.BackgroundCorrection.channel", 0);
        double sigma = (int) Prefs.get("MicrobeJ.BackgroundCorrection.sigma", 2);

        GenericDialog gd = new GenericDialog("BackgroundCorrection");

        
        gd.addNumericField("Sigma", sigma);
        
        if (nbChannels > 1) {
            gd.addChoice("Channels: ", channels, channels[channel]);
        }
        gd.showDialog();

        if (!gd.wasCanceled()) {
            sigma = gd.getNextNumber();

            if (nbChannels > 1) {
                channel = gd.getNextChoiceIndex();
            }

            Prefs.set("MicrobeJ.BackgroundCorrection.sigma", sigma);
            Prefs.set("MicrobeJ.BackgroundCorrection.channel", channel);

            if (channel == 0) {
                backgroundCorrect(imp, refChannel, sigma);
            } else {
                for (int c = 1; c <= nbChannels; c++) {
                    backgroundCorrect(imp, c, sigma);
                }
            }

        }
    }
    
    
    

    public static void backgroundCorrect(ImagePlus imp, int channel, double sigma) {

        ImageStack stack = imp.getStack();
        int nbSlices = imp.getNSlices();
        int nbFrames = imp.getNFrames();

        int position = 0;
        int positionMode = 0;
        switch (positionMode) {
            case 1://slices
                position = nbSlices;
                break;
            case 2://frames
                position = nbFrames;
                break;
            default:
                position = nbFrames * nbSlices;
                break;
        }

        int index;
        ImageProcessor ip;
        ImageProcessor ip2;
        IJ.showProgress(0);
        int slice = 1;
        int frame = 1;
        for (int i = 1; i <= position; i++) {
            index = imp.getStackIndex(channel, slice, frame);
            ip = stack.getProcessor(index);
            ip2 = ip.duplicate();
            ImProcessor.blurGaussian(ip2, sigma);
            ip.copyBits(ip2, 0, 0, Blitter.SUBTRACT);

            switch (positionMode) {
                case 1://slices
                    slice++;
                    break;
                case 2://frames
                    frame++;
                    break;
                default:
                    slice++;
                    if (slice > nbSlices) {
                        slice = 1;
                        frame++;
                    }
                    break;
            }
            IJ.showProgress((double) i / position);
        }
        imp.setStack(stack);
        imp.updateAndDraw();

    }

}
