
import com.ducret.resultJ.ImPlus;
import com.ducret.resultJ.RJ;
import ij.plugin.*;
import java.io.*;
import ij.*;
import ij.gui.*;
import ij.process.ImageProcessor;

/*  Converts a folder of images in any format supported by ImageJ's
File>Open command into TIFF, 8-bit TIFF, JPEG, GIF, PNG, PGM,
BMP, FITS, Text Image, ZIP or Raw. The plugin displays three dialogs.
In the first, select the source folder. In the second, select the format
you want to convert to. In the third, select the destination folder.
 */
public class BatchConverter_ implements PlugIn {

    private final static String[] formats = {"TIFF", "JPEG", "GIF", "PNG", "PGM", "BMP", "FITS", "Text Image", "ZIP", "Raw"};
    private static String format = "TIFF";

    private final static String[] methods = {"none", "bilinear", "bicubic"};
    private static String method = "bicubic";
    
    private final static String[] outputs = {"raw", "rgb"};
    private static String output = "raw";
    
    private static double scaleFactor = 1;
    private static Roi roi = null;

    public void run(String arg) {
        String dir1 = IJ.getDirectory("Select source folder...");
        if (dir1 == null) {
            return;
        }
        if (!showDialog()) {
            return;
        }
        String dir2 = IJ.getDirectory("Select destination folder...");
        if (dir2 == null) {
            return;
        }
        convert(dir1, dir2, format, method, roi, scaleFactor,output);
    }

    boolean showDialog() {
        GenericDialog gd = new GenericDialog("Batch Converter");
        gd.addStringField("Roi:", "0,0,0,0");
        gd.addNumericField("Scale Factor:", scaleFactor, 1);
        gd.addChoice("Method: ", methods, method);
        gd.addChoice("Format: ", formats, format);
        gd.addChoice("Output: ", outputs, output);

        gd.showDialog();
        if (gd.wasCanceled()) {
            return false;
        }
        //format = gd.getNextChoice();
        String rect = gd.getNextString();
        
        scaleFactor = gd.getNextNumber();
        method = gd.getNextChoice();
        format = gd.getNextChoice();
        output = gd.getNextChoice();
        

        if (rect.length() > 0) {
            String[] r = rect.split(",");
            if (r.length == 4) {
                int xRoi = Integer.parseInt(r[0]);
                int yRoi = Integer.parseInt(r[1]);
                int wRoi = Integer.parseInt(r[2]);
                int hRoi = Integer.parseInt(r[3]);
                if (wRoi > 0 && hRoi > 0) {
                    roi = new Roi(xRoi, yRoi, wRoi, hRoi);
                }
            }
        }

        return true;
    }

    public void convert(String dir1, String dir2, String format, String method, Roi r, double scaleFactor,String output) {
        IJ.log("\\Clear");
        IJ.log("dir1: " + dir1);
        IJ.log("dir2: " + dir2);
        String[] list = new File(dir1).list();
        if (list == null) {
            return;
        }

        int m;
        if ("bicubic".equals(method)) {
            m = ImageProcessor.BICUBIC;
        } else if ("bilinear".equals(method)) {
            m = ImageProcessor.BILINEAR;
        } else {
            m = ImageProcessor.NONE;
        }

        for (int i = 0; i < list.length; i++) {
            IJ.showProgress(i, list.length);
            IJ.log((i + 1) + ": " + list[i] + "  " + WindowManager.getImageCount());
            IJ.showStatus(i + "/" + list.length);
            boolean isDir = (new File(dir1 + list[i])).isDirectory();
            if (!isDir && !list[i].startsWith(".")) {
                ImagePlus img = IJ.openImage(dir1 + list[i]);
                if (img == null) {
                    continue;
                }

                ImagePlus img2,img3;

                if (r != null) {
                    img.setRoi(r);
                    img2 = new Duplicator().run(img);
                } else {
                    img2 = img;
                }

                img2 = (scaleFactor != 1) ? ImPlus.resize(img2, scaleFactor, scaleFactor, m) : img2;

                if("rgb".equals(output)){
                    img3 = ImPlus.getFlattenImage(img2, 1, 1, 0, 0);
                }else{
                    img3 = img2;
                }
                
                WindowManager.setTempCurrentImage(img3);
                IJ.saveAs(format, dir2 + list[i]);
			
                img.close();
                img2.close();
                img3.close();
                RJ.clearMemory();
            }
        }
        IJ.showProgress(1.0);
        IJ.showStatus("");
    }

    /**
     * This is the place to add code to process each image. The image is not
     * written if this method returns null.
     */
    public ImagePlus process(ImagePlus img) {
        double scale = 0.5;
        int width = img.getWidth();
        int height = img.getHeight();

        //ImageProcessor ip = img.getProcessor();
        //ip.setInterpolate(true);
        //ip = ip.resize((int)(width*scale), (int)(height*scale));
        //img.setProcessor(null, ip);
        return img;
    }

//	ImagePlus convertTo8Bits(ImagePlus img) {
//		ImageProcessor ip = img.getProcessor();
//		if (ip instanceof ColorProcessor) {
//			MedianCut mc = new MedianCut((int[])ip.getPixels(), ip.getWidth(), ip.getHeight());
//			img.setProcessor(null, mc.convertToByte(256));
//		} else {
//			ip = ip.convertToByte(true);
//			img.setProcessor(null, ip);
//		}
//		return img;
//	}
//
//	ImagePlus convertToRGB(ImagePlus img) {
//		ImagePlus img2 = img.createImagePlus();
//		img.updateImage();
//		img2.setProcessor(img.getTitle(), new ColorProcessor(img.getImage()));
//		return img2;
//	}
//
//	ImagePlus getFirstSlice(ImagePlus img) {
//		ImagePlus img2 = img.createImagePlus();
//		img2.setProcessor(img.getTitle(), img.getProcessor());
//		return img2;
//	}
//
//	ImagePlus convertToGrayscale(ImagePlus img) {
//		ImagePlus img2 = img.createImagePlus();
//		img2.setProcessor(img.getTitle(), img.getProcessor().convertToByte(true));
//		return img2;
//	}
//
//	/**	Run Batch_Converter using a command something like
//			"java -cp ij.jar;. Batch_Converter c:\dir1\ c:\dir2\"
//		or (Unix)
//			"java -cp ij.jar:. Batch_Converter /users/wayne/dir1 /users/wayne/dir2/"
//	*/
//	public static void main(String args[]) {
//		if (args.length<2)
//			IJ.log("usage: java Batch_Converter srcdir dstdir");
//		else {
//			new BatchConverter_().convert(args[0], args[1], "Jpeg");
//			System.exit(0);
//		}
//	}
}
