
import ij.*;
import ij.process.*;
import ij.gui.*;
import ij.io.*;
import java.util.*;
//import java.awt.*;
import java.awt.geom.*;
import java.awt.Font;
import java.awt.Color;
import ij.plugin.*;
import ij.plugin.filter.*;
import ij.plugin.frame.*;
import com.ducret.resultJ.*;

//import
public class Frap_converter implements PlugInFilter {

    ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return DOES_8G + DOES_16 + DOES_32 + STACK_REQUIRED;
    }

    public void run(ImageProcessor ip) {
        String title = imp.getShortTitle();

        Range[] dRange = ImPlus.getChannelDisplayRange(imp);

        ImagePlus imp2 = imp.duplicate();

        int width = imp2.getWidth();
        int height = imp2.getHeight();

        int nChannel = imp2.getNChannels();
        ImPlus image = new ImPlus(imp2);

        GenericDialog gd = new GenericDialog("Frap Converter");

        //gd.addNumericField("phase:", (int) Prefs.get("MicrobeJ.frapConverter.phase", 0), 0);
        gd.addNumericField("pre-bleach:", (int) Prefs.get("MicrobeJ.frapConverter.prebleach", 1), 0);
        gd.addNumericField("post-bleach:", (int) Prefs.get("MicrobeJ.frapConverter.postbleach", 2), 0);
        //gd.addNumericField("phase:", (int) Prefs.get("MicrobeJ.frapConverter.phase", 3), 0);

        gd.showDialog();

        if (gd.wasCanceled()) {
            return;
        }

        //int iPhase = (int) gd.getNextNumber();
        int iPreBleach = (int) gd.getNextNumber();
        int iPostBleach = (int) gd.getNextNumber();
        int iPhase = (int) gd.getNextNumber();

        Prefs.set("MicrobeJ.frapConverter.prebleach", iPreBleach);
        Prefs.set("MicrobeJ.frapConverter.postbleach", iPostBleach);
        //Prefs.set("MicrobeJ.frapConverter.phase", iPhase);

        iPreBleach--;
        iPostBleach--;
        //iPhase--;
        ImageProcessor[][] processors = new ImageProcessor[nChannel][];
        String[] labels = new String[nChannel];

        for (int i = 0; i < nChannel; i++) {
            processors[i] = image.getProcessors(i);
            labels[i] = image.getSliceLabel(i);
        }

        ImagePlus[] stacks = new ImagePlus[nChannel];
        Range[] dRange2 = new Range[nChannel];
        ImageStack s;
        int k = 0;
        int q;
        for (int i = 0; i < nChannel; i++) {
            if (i != iPostBleach) {
                s = new ImageStack(width, height);
                s.addSlice(processors[i][0].duplicate());
                q = (i == iPreBleach) ? iPostBleach : i;
                for (int j = 0; j < processors[i].length; j++) {
                    s.addSlice(processors[q][j].duplicate());
                }
                stacks[k] = new ImagePlus(labels[i], s);
                dRange2[k] = dRange[i];
                k++;
            }
        }

        stacks = Arrays.copyOf(stacks, k);
        dRange2 = Arrays.copyOf(dRange2, k);

        ImagePlus imp3 = ImPlus.getHyperStack(title + "_f", stacks, true);

        if (imp3 != null) {
            imp3.setCalibration(imp.getCalibration());
            ImPlus.setChannelDisplayRange(imp3, dRange2);
            imp3.show();
        }
    }

}
