
import ij.*;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.measure.Calibration;
import ij.measure.Measurements;
import ij.plugin.ChannelSplitter;
import ij.process.*;
import ij.plugin.filter.*;
import ij.measure.CurveFitter;
import static ij.plugin.filter.PlugInFilter.DOES_16;
import static ij.plugin.filter.PlugInFilter.DOES_32;
import static ij.plugin.filter.PlugInFilter.DOES_8G;
import static ij.plugin.filter.PlugInFilter.STACK_REQUIRED;
import ij.plugin.frame.RoiManager;

import com.ducret.resultJ.Result;
import com.ducret.resultJ.Data;
import ij.gui.Overlay;
//import

public class MeasureStack implements PlugInFilter {

    ImagePlus imp;

    private static final int OPTIONS = Measurements.MEAN + Measurements.MEDIAN + Measurements.STD_DEV + Measurements.MODE + Measurements.MIN_MAX;

    private static final String[] MEASUREMENT = new String[]{"mean", "median", "stdev", "mode", "min", "max"};

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return DOES_8G + DOES_16 + DOES_32 + STACK_REQUIRED;
    }

    public void run(ImageProcessor ip) {
        Roi r = imp.getRoi();

        if (!(r == null)) {
            int roiType = r.getType();
//            if (!(roiType == Roi.LINE || roiType == Roi.POLYLINE)) {
//                IJ.error("Line or rectangular selection required.");
//                return;
//            }
        } else {
            IJ.error("Selection required");
            return;
        }

        int channel = (int) Prefs.get("MicrobeJ.measureStack.channel", 0);
        boolean roiManager = (boolean) Prefs.get("MicrobeJ.measureStack.roiManager", false);
        int measurement = (int) Prefs.get("MicrobeJ.measureStack.measurement", 0);
        double interval = (int) Prefs.get("MicrobeJ.measureStack.interval", 15);
        String[] aChannels = new String[imp.getChannel()];

        for (int i = 0; i < aChannels.length; i++) {
            aChannels[i] = "channel " + (i + 1);
        }

        GenericDialog gd = new GenericDialog("Measure Stack");

        gd.addChoice("Channel:", aChannels, aChannels[channel]);
        gd.addChoice("Measurement:", MEASUREMENT, MEASUREMENT[measurement]);
        gd.addNumericField("Time interval(s):", interval, 0);
        gd.addCheckbox("RoiManager", roiManager);

        gd.showDialog();
        if (!gd.wasCanceled()) {

            channel = gd.getNextChoiceIndex();
            measurement = gd.getNextChoiceIndex();
            interval = gd.getNextNumber();
            roiManager = gd.getNextBoolean();

            Prefs.set("MicrobeJ.measureStack.channel", channel);
            Prefs.set("MicrobeJ.measureStack.roiManager", roiManager);
            Prefs.set("MicrobeJ.measureStack.measurement", measurement);
            Prefs.set("MicrobeJ.measureStack.interval", interval);

            Calibration calibration = imp.getCalibration();
//        int nbSlices = imp.getNSlices();
//        int nbFrames = imp.getNFrames();

            ImagePlus[] channels = ChannelSplitter.split(imp);

            Roi[] rois = null;

            if (roiManager) {
                RoiManager manager = RoiManager.getInstance();
                rois = manager.getRoisAsArray();
            } else {
                rois = new Roi[1];
                rois[0] = r;
            }
            double[][][] signal = new double[rois.length][][];
            double[] time;
            ImageProcessor ip2;
            int nbRows = 0;
            ImageStatistics stat;
            CurveFitter fitter;
            ImageStack stack = channels[channel].getImageStack();
            for (int q = 0; q < rois.length; q++) {
                nbRows = stack.size();
                signal[q] = new double[4][nbRows];
                time = new double[nbRows];
                for (int s = 0; s < nbRows; s++) {
                    ip2 = stack.getProcessor(s + 1);
                    ip2.setRoi(rois[q]);
                    stat = ImageStatistics.getStatistics(ip2, OPTIONS, calibration);
                    time[s] = interval * (s + 1);
                    switch (measurement) {
                        case 0:
                            signal[q][0][s] = stat.mean;
                            break;
                        case 1:
                            signal[q][0][s] = stat.median;
                            break;
                        case 2:
                            signal[q][0][s] = stat.stdDev;
                            break;
                        case 3:
                            signal[q][0][s] = stat.mode;
                            break;
                        case 4:
                            signal[q][0][s] = stat.min;
                            break;
                        case 5:
                            signal[q][0][s] = stat.max;
                            break;
                    }
                    ip2.setRoi((Roi) null);
                }
                fitter = new CurveFitter(time, signal[q][0]);

                fitter.doFit(CurveFitter.EXP_WITH_OFFSET);

                for (int s = 0; s < nbRows; s++) {
                    signal[q][1][s] = fitter.f(time[s]);
                    signal[q][2][s] = signal[q][0][s] - signal[q][1][s];
                    signal[q][3][s] = fitter.getRSquared();
                }
            }

//            ResultsTable table = new ResultsTable();
//            for (int s = 0; s < nbRows; s++) {
//                table.setValue("Time", s, interval * (s + 1));
//                for (int c = 0; c < signal.length; c++) {
//                    table.setValue(MEASUREMENT[measurement] + "_" + (c + 1), s, signal[c][0][s]);
//                    table.setValue("fit_" + (c + 1), s, signal[c][1][s]);
//                    table.setValue("residual_" + (c + 1), s, signal[c][2][s]);
//                    table.setValue("r_" + (c + 1), s, signal[c][3][s]);
//                }
//            }
//table.show("Values");
            Result result = new Result();
            Result result2;
            Data data1, data2;
            Overlay overlay;

            for (int c = 0; c < signal.length; c++) {
                data1 = new Data();
                overlay = new Overlay();
                overlay.add(rois[c]);
                data1.addOverlay(overlay);
                data1.set("index", (c + 1));
                data1.set("name", rois[c].getName());

                result2 = new Result("intensity");
                for (int s = 0; s < nbRows; s++) {
                    data2 = new Data();
                    data2.set("index", (c + 1));
                    data2.set("time", interval * (s + 1));
                    data2.set(MEASUREMENT[measurement], signal[c][0][s]);
                    data2.set("fit", signal[c][1][s]);
                    data2.set("residual", signal[c][2][s]);
                    data2.set("r", signal[c][3][s]);

                    result2.add(data2);
                }
                result.add(data1, result2);
            }

            result.show();
        }
    }

}
