
import com.ducret.resultJ.ImPlus;
import com.ducret.resultJ.ImProcessor;
import com.ducret.resultJ.RJ;
import com.ducret.resultJ.Range;
import ij.*;
import ij.process.*;
import ij.gui.*;
import ij.measure.Calibration;
import ij.plugin.*;
import ij.plugin.filter.*;
import ij.plugin.frame.RoiManager;

public class Straighten_ implements PlugInFilter {

    ImagePlus imp;
    private int lineWidth;
    private boolean roiManager;
    private boolean autocrop;

    @Override
    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return DOES_8G + DOES_16 + DOES_32;//+ STACK_REQUIRED;
    }

    @Override
    public void run(ImageProcessor ip) {
        Roi r = imp.getRoi();
        
        Calibration c = imp.getCalibration();

        lineWidth = (int) Prefs.get("MicrobeJ.straighten.lineWidth", 1);
        roiManager = (boolean) Prefs.get("MicrobeJ.straighten.roiManager", false);
        autocrop = (boolean) Prefs.get("MicrobeJ.straighten.autoCrop", false);

        lineWidth = (r != null && r.getStrokeWidth() > 0) ? (int) r.getStrokeWidth() : lineWidth;

        GenericDialog gd = new GenericDialog("KymoGraph");
        gd.addNumericField("Line Width:", lineWidth, 0);
        gd.addCheckbox("RoiManager", roiManager);
        gd.addCheckbox("AutoCrop", autocrop);

        gd.showDialog();
        if (!gd.wasCanceled()) {
            lineWidth = (int) gd.getNextNumber();
            roiManager = gd.getNextBoolean();
            autocrop = gd.getNextBoolean();

            Prefs.set("MicrobeJ.straighten.lineWidth", lineWidth);
            Prefs.set("MicrobeJ.straighten.roiManager", roiManager);
            Prefs.set("MicrobeJ.straighten.autoCrop", autocrop);

            RoiManager manager = RoiManager.getInstance();
            Roi[] rois = null;
            //ArrayList<Roi> output = new ArrayList<Roi>();
            if (manager != null) {
                rois = manager.getRoisAsArray();
            }

            ImagePlus[] channels = ChannelSplitter.split(imp);
            ImagePlus[] output = new ImagePlus[channels.length];
            ImageProcessor[] sProcessors;
            int k;
            Range width = new Range(0, 0);
            Range height = new Range(0, 0);
            ImageStack stack;
            ImagePlus temp;
            int wMax, hMax;
            Roi r2 = r;
            for (int c = 0; c < channels.length; c++) {
                stack = channels[c].getImageStack();
                sProcessors = new ImageProcessor[stack.getSize()];
                k = 0;

                for (int s = 0; s < sProcessors.length; s++) {
                    temp = new ImagePlus("", stack.getProcessor(s + 1));

                    if (rois != null) {
                        r2 = getRoi(rois, (s + 1), r2);
                    } else {
                        r2 = r;
                    }

                    temp.setRoi(r2);
                    sProcessors[k] = new Straightener().straighten(temp, r2, lineWidth);
                    width.update(sProcessors[k].getWidth());
                    height.update(sProcessors[k].getHeight());
                    //ImProcessor.show(">", sProcessors[c][k]);
                    k++;
                }

                wMax = (int) width.max;
                hMax = (int) height.max;

                stack = new ImageStack(wMax, hMax);
                ImageProcessor ipTemp;
                for (int s = 0; s < sProcessors.length; s++) {
                    ipTemp = sProcessors[s].createProcessor(wMax, hMax);
                    ipTemp.copyBits(sProcessors[s], (wMax / 2) - (sProcessors[s].getWidth() / 2), (hMax / 2) - (sProcessors[s].getHeight() / 2), FloatBlitter.ADD);
                    stack.addSlice(ipTemp);
                }

                if (autocrop) {
                    output[c] = new ImagePlus("", ImProcessor.autoCrop(stack, 0));
                } else {
                    output[c] = new ImagePlus("", stack);
                }

                //output[c].show();
            }

            ImagePlus straigthen = ImPlus.getHyperStack(ImPlus.getTitleWithSuffix(imp.getTitle(), "_s"), output);

            
            straigthen.setCalibration(c);
            straigthen.show();
        }

    }

    public static Roi getRoi(Roi[] input, int position, Roi rDefault) {
        if (input != null) {
            for (Roi r : input) {
                if (r != null) {
                    if ((r.getPosition() > 0 && r.getPosition() == position) || (r.getPosition() == 0 && (position == r.getTPosition() || position == r.getZPosition()))) {
                        return r;
                    }
                }
            }
        }
        return rDefault;
    }

}
