
import ij.*;
import ij.process.*;
import ij.gui.*;
import ij.plugin.*;
import ij.plugin.filter.*;

public class SubtractFirst_Frame implements PlugInFilter {

    ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return DOES_8G + DOES_16 + STACK_REQUIRED;
    }

    public void run(ImageProcessor ip) {
        ImageStack iStack = imp.getImageStack();
        if (iStack.getSize() > 1) {
            ImageStack iStack2 = new ImageStack(imp.getWidth(), imp.getHeight());
            ImageProcessor ip0 = iStack.getProcessor(1);
            ImageProcessor ip1;
            for (int i = 1; i < iStack.getSize(); i++) {
                ip1 = iStack.getProcessor(i + 1).duplicate();
                ip1.copyBits(ip0,0,0,ShortBlitter.SUBTRACT);
                iStack2.addSlice(ip1.duplicate());
            }
            new ImagePlus(imp.getTitle() + "_", iStack2).show();
        }
    }
}
