
import com.ducret.resultJ.Geometry;
import ij.plugin.*;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.WindowManager;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.plugin.frame.RoiManager;
import ij.process.ImageProcessor;
import java.awt.Rectangle;
import java.util.ArrayList;

//import
public class Tile_Generator implements PlugIn {

    public void run(String arg) {

        GenericDialog gd = new GenericDialog("Tiles Generator");

        gd.addNumericField("count/frame", (int) Prefs.get("MicrobeJ.TileGenerator.count", 10), 0);
        gd.addNumericField("width", (int) Prefs.get("MicrobeJ.TileGenerator.width", 256), 0);
        gd.addNumericField("height", (int) Prefs.get("MicrobeJ.TileGenerator.height", 256), 0);
        gd.addCheckbox("Roi manager", (boolean) Prefs.get("MicrobeJ.TileGenerator.Roimanager", false));

        ArrayList<String> ImList = new ArrayList<String>();
        int[] IDList = WindowManager.getIDList();
        for (int i = 0; i < IDList.length; i++) {
            ImagePlus imp1 = WindowManager.getImage(IDList[i]);
            ImList.add(imp1.getTitle());
        }
        String[] ImListA = ImList.toArray(new String[0]);

        String imSourceName = (String) Prefs.get("MicrobeJ.TileGenerator.source", "");
        String imTargetName = (String) Prefs.get("MicrobeJ.TileGenerator.target", "");

        gd.addChoice("Source", ImListA, imSourceName.isEmpty() ? (ImListA.length > 0 ? ImListA[0] : "") : imSourceName);
        gd.addChoice("Target", ImListA, imTargetName.isEmpty() ? (ImListA.length > 1 ? ImListA[1] : "") : imTargetName);

        gd.showDialog();

        if (gd.wasCanceled()) {
            return;
        }

        int c = (int) gd.getNextNumber();
        int w = (int) gd.getNextNumber();
        int h = (int) gd.getNextNumber();

        boolean roiManager = gd.getNextBoolean();

        imSourceName = gd.getNextChoice();
        imTargetName = gd.getNextChoice();

        Prefs.set("MicrobeJ.TileGenerator.count", c);
        Prefs.set("MicrobeJ.TileGenerator.width", w);
        Prefs.set("MicrobeJ.TileGenerator.height", h);
        Prefs.set("MicrobeJ.TileGenerator.source", imSourceName);
        Prefs.set("MicrobeJ.TileGenerator.target", imTargetName);
        Prefs.set("MicrobeJ.TileGenerator.Roimanager", roiManager);

        ImagePlus imSource = WindowManager.getImage(imSourceName);
        ImagePlus imTarget = WindowManager.getImage(imTargetName);

        if (imSource.getWidth() != imTarget.getWidth() || imSource.getHeight() != imTarget.getHeight()) {
            IJ.error("Source & Target Image dimension must be equal");
            return;
        }

        int imWidth = imSource.getWidth();
        int imHeight = imSource.getHeight();

        ImageStack stackSource = imSource.getStack();
        ImageStack stackTarget = imTarget.getStack();

        int sCount = stackSource.getSize();

        if (sCount != stackTarget.getSize()) {
            IJ.error("Source & Target stack size must be equal");
            return;
        }

        ImageStack stackSourceTile = null;// = new ImageStack(w, h);
        ImageStack stackTargetTile = null;// = new ImageStack(w, h);

        ImageProcessor pSource, pTarget;
        ImageProcessor pSource2, pTarget2;

        if (roiManager) {
            RoiManager manager = RoiManager.getInstance();
            if (manager != null) {
                Rectangle bound;
                w = 0;
                h = 0;
                for (Roi r : manager.getRoisAsArray()) {
                    if (r != null) {
                        bound = r.getBounds();
                        if (bound.width > w) {
                            w = bound.width;
                        }
                        if (bound.height > h) {
                            h = bound.height;
                        }
                    }
                }

                stackSourceTile = new ImageStack(w, h);
                stackTargetTile = new ImageStack(w, h);

                int p;
                int q = 1;
                for (int s = 1; s <= sCount; s++) {
                    pSource = stackSource.getProcessor(s);
                    pTarget = stackTarget.getProcessor(s);
                    for (Roi r : manager.getRoisAsArray()) {
                        p = r.getPosition();
                        if (p == 0 || p == s) {
                            pSource.setRoi(r);
                            pSource2 = pSource.crop();
                            pTarget.setRoi(r);
                            pTarget2 = pTarget.crop();
                            stackSourceTile.addSlice(q + "_img",pSource2);
                            stackTargetTile.addSlice(q + "_masks",pTarget2);
                            q++;
                        }
                    }
                }
            }
        } else {
            stackSourceTile = new ImageStack(w, h);
            stackTargetTile = new ImageStack(w, h);
            int xRoi, yRoi;
            float max;
            int maxTile = c * 2;

            for (int i = 1; i <= sCount; i++) {
                pSource = stackSource.getProcessor(i);
                pTarget = stackTarget.getProcessor(i);
                int q = 0;
                for (int j = 0; j < maxTile; j++) {
                    xRoi = (int) (Math.random() * (imWidth - w));
                    yRoi = (int) (Math.random() * (imHeight - h));
                    pSource.setRoi(xRoi, yRoi, w, h);
                    pTarget.setRoi(xRoi, yRoi, w, h);
                    pSource2 = pSource.crop();
                    pTarget2 = pTarget.crop();
                    max = Geometry.max(pTarget2.getFloatArray());
                    //RJ.l(i + " : " + j + ">" + max);
                    if (max >= 255) {
                        stackSourceTile.addSlice((q+1) + "_img",pSource2);
                        stackTargetTile.addSlice((q+1) + "_masks",pTarget2);
                        q++;
                    }
                    if (q >= c) {
                        break;
                    }
                }
            }
        }

        if (stackSourceTile != null) {
            ImagePlus imTileSource = new ImagePlus("Source", stackSourceTile);
            imTileSource.show();
        }
        if (stackTargetTile != null) {
            ImagePlus imTileTarget = new ImagePlus("Target", stackTargetTile);
            imTileTarget.show();
        }

    }
}
