
import ij.*;
import ij.process.*;
import ij.gui.*;
import java.awt.*;
import ij.plugin.filter.*;
import com.ducret.resultJ.*;
import java.util.Arrays;

//Plugin to equalize stack of image
public class TranslateProcessor_ implements ExtendedPlugInFilter, DialogListener {

    private ImagePlus imp;
    private ImageStack stack;

    private static int xOffset;
    private static int yOffset;

    private ImageProcessor[] tProcessor;

    private static int nbChannels;
    private static int refSlice;
    private static int refFrame;

    private GenericDialog gd;
    private PlugInFilterRunner pfr;
    private int flags = DOES_8G + DOES_16 + DOES_32 + DOES_STACKS;

    @Override
    public int setup(String arg, ImagePlus imp) {

        if (imp == null) {
            return flags;
        }

        this.imp = imp;

        nbChannels = imp.getNChannels();
        refSlice = imp.getZ();
        refFrame = imp.getT();

        tProcessor = new ImageProcessor[nbChannels];
        stack = imp.getImageStack();
        int index;
        ImageProcessor ip;
        for (int i = 0; i < nbChannels; i++) {
            index = imp.getStackIndex((i + 1), refSlice, refFrame);
            ip = stack.getProcessor(index);
            tProcessor[i] = (ip != null) ? ip.duplicate() : null;
        }
        return flags;
    }

    @Override
    public void run(ImageProcessor ip) {
        if (gd.wasOKed()) {
            translate(0, 0);
            translate(imp, xOffset, yOffset);
        } else if (gd.wasCanceled()) {
            translate(0, 0);
        } else {
            translate(xOffset, yOffset);
        }
    }

    private void translate(int xOffset, int yOffset) {
        int index;
        for (int i = 0; i < nbChannels; i++) {
            index = imp.getStackIndex((i + 1), refSlice, refFrame);
            translate(stack.getProcessor(index), xOffset, yOffset, tProcessor[i]);
        }
//        stack.setProcessor(ip2, index);
//        imp.setStack(stack);
        imp.updateAndDraw();
    }

    public static void translate(ImageProcessor target, int xOffset, int yOffset) {
        translate(target, xOffset, yOffset, null);
    }

    public static void translate(ImageProcessor target, int xOffset, int yOffset, ImageProcessor ipSource) {
        ipSource = (ipSource == null) ? target.duplicate() : ipSource;
        int width = target.getWidth();
        int height = target.getHeight();
        int x2, y2;
        float val;
        xOffset = checkOffset(xOffset, width);
        yOffset = checkOffset(yOffset, height);
        for (int x = 0; x < width; x++) {
            for (int y = 0; y < height; y++) {
                val = ipSource.getf(x, y);
                x2 = getOffset(x, xOffset, width);
                y2 = getOffset(y, yOffset, height);
                target.setf(x2, y2, val);
            }
        }
    }

    private static int checkOffset(int offset, int max) {
        if (Math.abs(offset) >= max) {
            return (offset > 0) ? (int) ((double) offset % max) : (int) -((double) Math.abs(offset) % max);
        } else {
            return offset;
        }
    }

    private static int getOffset(int c, int offset, int max) {

        int output = c + offset;
        if (output >= max) {
            return output - max;
        } else if (output < 0) {
            return output + max;
        } else {
            return output;
        }
    }

    @Override
    public int showDialog(ImagePlus imp, String command, PlugInFilterRunner pfr) {
        this.pfr = pfr;

        xOffset = (int) Prefs.get("MicrobeJ.translate.xOffset", 0);
        yOffset = (int) Prefs.get("MicrobeJ.translate.yOffset", 0);

        gd = new GenericDialog("Translate Processor");

        int digits = xOffset == (int) xOffset && yOffset == (int) yOffset ? 1 : 3;
        gd.addNumericField("X offset (pixels): ", xOffset, digits, 8, "");
        gd.addNumericField("Y offset (pixels): ", yOffset, digits, 8, "");

        gd.addPreviewCheckbox(pfr, "Preview");
        gd.addDialogListener(this);
        gd.showDialog();

        if (gd.wasCanceled()) {
            translate(0, 0);
            return DONE;
        }
        return IJ.setupDialog(imp, flags);
    }

    @Override
    public boolean dialogItemChanged(GenericDialog gd, AWTEvent e) {

        xOffset = (int) gd.getNextNumber();
        yOffset = (int) gd.getNextNumber();

        Prefs.set("MicrobeJ.translate.xOffset", xOffset);
        Prefs.set("MicrobeJ.translate.yOffset", yOffset);

        if (gd.invalidNumber()) {
            if (gd.wasOKed()) {
                IJ.error("Offset is invalid.");
            }
            return false;
        }

        return true;
    }

    @Override
    public void setNPasses(int nPasses) {
    }

    public static void translate(ImagePlus imp, int xOffset, int yOffset) {
        ImageStack stack = imp.getStack();
        Roi r = imp.getRoi();
        imp.setRoi((Roi) null);
        IJ.showProgress(0);
        int tot = stack.getSize();
        for (int i = 1; i <= tot; i++) {
            translate(stack.getProcessor(i), xOffset, yOffset);
            IJ.showProgress((double) i / tot);
        }
        //imp.setStack(stack);
        imp.setRoi(r);
        imp.updateAndDraw();

    }

}
