
import ij.*;
import ij.process.*;
import ij.gui.*;
import java.awt.*;
import ij.plugin.filter.*;
import ij.plugin.frame.Recorder;
import ij.measure.ResultsTable;

//Plugin to equalize stack of image
public class Equalize_ implements PlugInFilter {

    ImagePlus imp;
    //ImageProcessor ref;
    //ImageStack stack;
    //int width, height;
    //int refChannel, refPosition, refSlice, refFrame;
    //boolean frameStack;
    private static final String[] positions = new String[]{"both", "slices", "frames"};
    private static final String[] channels = new String[]{"current", "all"};
    private static final String[] methods = {"Addition", "Multiplication"};
    private static final String[] modes = {"Mean", "Min", "Max", "Median"};

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return DOES_8G + DOES_16 + DOES_32 + STACK_REQUIRED;
    }

    public void run(ImageProcessor ip) {
        //width = imp.getWidth();
        //height = imp.getHeight();
        //stack = imp.getStack();

        int nbChannels = imp.getNChannels();
        int nbSlices = imp.getNSlices();
        int nbFrames = imp.getNFrames();

        int refChannel = imp.getC();
        int method, statMode, position, channel;

        method = (int) Prefs.get("MicrobeJ.equalize.method", 0);
        statMode = (int) Prefs.get("MicrobeJ.equalize.statmode", 0);
        position = (int) Prefs.get("MicrobeJ.equalize.position", 0);
        channel = (int) Prefs.get("MicrobeJ.equalize.channel", 0);

        GenericDialog gd = new GenericDialog("Equalize");
        gd.addChoice("Mode: ", modes, modes[method]);
        gd.addChoice("Method: ", methods, methods[statMode]);

        if (nbSlices > 1 && nbFrames > 1) {
            gd.addChoice("Positions: ", positions, positions[position]);
        }
        if (nbChannels > 1) {
            gd.addChoice("Channels: ", channels, channels[channel]);
        }
        gd.showDialog();

        if (!gd.wasCanceled()) {
            method = gd.getNextChoiceIndex();
            statMode = gd.getNextChoiceIndex();

            if (nbSlices > 1 && nbFrames > 1) {
                position = gd.getNextChoiceIndex();
            }

            if (nbChannels > 1) {
                channel = gd.getNextChoiceIndex();
            }

            Prefs.set("MicrobeJ.equalize.method", method);
            Prefs.set("MicrobeJ.equalize.statmode", statMode);
            Prefs.set("MicrobeJ.equalize.position", position);
            Prefs.set("MicrobeJ.equalize.channel", channel);

            if (channel == 0) {
                equalize(imp, refChannel, statMode, method, position);
            } else {
                for (int c = 1; c <= nbChannels; c++) {
                    equalize(imp, c, statMode, method, position);
                }
            }

        }
    }

    public static void equalize(ImagePlus imp, int channel, int statMode, int method, int positionMode) {

        ImageStack stack = imp.getStack();
        int nbSlices = imp.getNSlices();
        int nbFrames = imp.getNFrames();

        int position = 0;
        switch (positionMode) {
            case 1://slices
                position = nbSlices;
                break;
            case 2://frames
                position = nbFrames;
                break;
            default:
                position = nbFrames * nbSlices;
                break;
        }

        int index;
        ImageProcessor ip;
        ImageStatistics stat;
        double val, refVal = 0;
        Roi r = imp.getRoi();
        IJ.showProgress(0);
        int slice = 1;
        int frame = 1;
        for (int i = 1; i <= position; i++) {
            index = imp.getStackIndex(channel, slice, frame);
            ip = stack.getProcessor(index);
            //new ImagePlus(i + ">", ip2.duplicate()).show();
            ip.setRoi(r);
            stat = ip.getStatistics();
            ip.setRoi((Roi) null);
            switch (statMode) {
                case 1:
                    val = stat.min;
                    break;
                case 2:
                    val = stat.max;
                    break;
                case 3:
                    val = stat.median;
                    break;
                default:
                    val = stat.mean;
                    break;
            }
            if (i == 1) {
                refVal = val;
            } else {
                switch (method) {
                    case 1:
                        ip.multiply(refVal / val);
                    default:
                        ip.add(refVal - val);
                }
                stack.setProcessor(ip, index);
            }

            switch (positionMode) {
                case 1://slices
                    slice++;
                    break;
                case 2://frames
                    frame++;
                    break;
                default:
                    slice++;
                    if (slice > nbSlices) {
                        slice = 1;
                        frame++;
                    }
                    break;
            }

            //slice += ((frameStack) ? 0 : 1);
            //frame += ((frameStack) ? 1 : 0);
            IJ.showProgress((double) i / position);
        }
        imp.setStack(stack);
        imp.updateAndDraw();

    }

}
