
import com.ducret.microbeJ.ImMask;
import com.ducret.microbeJ.Parameter;
import ij.plugin.*;
import com.ducret.resultJ.ImPlus;
import com.ducret.resultJ.ImPosition;
import com.ducret.resultJ.RJ;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.process.ImageProcessor;
import java.io.File;
import com.ducret.resultJ.Property;
import ij.process.FloatProcessor;

public class BatchMask_ implements PlugIn {

    @Override
    public void run(String arg) {

        //String mExtension = "_m";
        String settings = Prefs.get("MicrobeJ.maskBatch.settings", "");
        String folder = Prefs.get("MicrobeJ.maskBatch.folder", "");
        boolean recursive = Prefs.get("MicrobeJ.maskBatch.recursive", false);
        boolean override = Prefs.get("MicrobeJ.maskBatch.override", false);
        String suffix = Prefs.get("MicrobeJ.maskBatch.suffix", "_m");
        GenericDialog gd = new GenericDialog("Mask Batch");

        gd.addFileField("Settings:", settings);
        gd.addDirectoryField("Folder:", folder);
        gd.addStringField("Suffix:", suffix);
        gd.addCheckbox("Recursive", recursive);
        gd.addCheckbox("Override", override);

        gd.showDialog();

        if (!gd.wasCanceled()) {

            settings = gd.getNextString();
            folder = gd.getNextString();
            suffix = gd.getNextString();
            recursive = gd.getNextBoolean();

            Prefs.set("MicrobeJ.maskBatch.settings", settings);
            Prefs.set("MicrobeJ.maskBatch.folder", folder);
            Prefs.set("MicrobeJ.maskBatch.suffix", suffix);
            Prefs.set("MicrobeJ.maskBatch.recursive", recursive);
            Prefs.set("MicrobeJ.maskBatch.override", override);

            Property p1 = new Property(new File(settings));
            Parameter p = new Parameter(p1.getP("bacteria"));

            File parent = new File(folder);
            if (parent.exists() && parent.isDirectory()) {
                File[] images = ImPlus.getImageFiles(parent, recursive);
                for (File i : images) {
                    String name;
                    String nMask;
                    ImagePlus imp;
                    ImagePlus mask;
                    File fMask;
                    if (i.exists() && i.isFile()) {
                        name = RJ.removeExtension(i.getName());
                        if (!name.endsWith(suffix)) {
                            RJ.l(">" + name);
                            nMask = name + suffix;
                            fMask = new File(IJ.addSeparator(i.getParent()) + nMask + ".tif");
                            if (override || !fMask.exists()) {
                                imp = ImPlus.loadImagePlus(i.getPath());
                                mask = getMask(imp, p);
                                mask.setTitle(nMask);
                                RJ.l("->" + nMask);
                                IJ.saveAsTiff(mask, fMask.getPath());
                            }
                        }
                    }
                }
            }
        }
    }

    public static ImagePlus getMask(ImagePlus imp, Parameter parameters) {
        int nbFrame = imp.getNFrames();
        int nbSlice = imp.getNSlices();
        int nbChannel = imp.getNChannels();
        int width = imp.getWidth();
        int height = imp.getHeight();
        ImPlus image = new ImPlus(imp);
        int c = parameters.getI("CHANNEL_INDEX", 0);
        ImMask m;
        ImageStack oStack = new ImageStack(width, height);
        ImPosition pos;
        ImageProcessor ip;
//        ImProcessor test;
        int p = 0;
//        String label;
        //RJ.l(">" + nbFrame + " / " + nbSlice);
        for (int s = 0; s < nbSlice; s++) {
            for (int f = 0; f < nbFrame; f++) {
                pos = new ImPosition(c, p++, s, f);
//                test = image.getImProcessor(pos);
//                label = image.getLabel(pos);
                m = ImMask.getImMask(image, pos, parameters, 0, 0);
                ip = m.getMask();
                if (ip == null) {
                    ip = new FloatProcessor(width, height);
                }
                oStack.addSlice(ip);
            }
        }
        ImagePlus output = new ImagePlus("", oStack);
        output.setDimensions(1, nbSlice, nbFrame);
        //output.show();
        return output;
    }
}
