
import ij.*;
import ij.process.*;
import ij.gui.*;
import ij.io.*;
//import java.awt.*;
import java.awt.geom.*;
import java.awt.Font;
import java.awt.Color;
import ij.plugin.*;
import ij.plugin.filter.*;
import ij.plugin.frame.*;
import com.ducret.microbeJ.*;

//import
public class ChannelSwapper_ implements PlugInFilter {

    ImagePlus imp;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return DOES_8G + DOES_16 + DOES_32 + STACK_REQUIRED;
    }

    public void run(ImageProcessor ip) {
        int width = imp.getWidth();
        int height = imp.getHeight();
        String title = imp.getTitle();
        //ImPlus image = new ImPlus(imp);

        ImageStack stack = imp.getImageStack();

        int nChannel = imp.getNChannels();
        int nSlice = imp.getNSlices();
        int nFrame = imp.getNFrames();

        GenericDialog gd = new GenericDialog("Channel Swapper");

        for (int i = 0; i < nChannel; i++) {
            gd.addNumericField("ch" + (i + 1) + ": ", (int) Prefs.get("MicrobeJ.channelSwapper.ch" + (i + 1), i + 1), 0);

        }

        gd.showDialog();

        if (gd.wasCanceled()) {
            return;
        }

        int[] nIndex = new int[nChannel];

        for (int i = 0; i < nChannel; i++) {
            nIndex[i] = (int) gd.getNextNumber();
            Prefs.set("MicrobeJ.channelSwapper.ch" + (i + 1), nIndex[i]);
        }

        int n1;
        for (int s = 1; s <= nSlice; s++) {
            for (int f = 1; f <= nFrame; f++) {
                ImageProcessor[] ipChannel = new ImageProcessor[nChannel];
                String[] ipLabel = new String[nChannel];
                for (int c = 0; c < nChannel; c++) {
                    n1 = imp.getStackIndex(c + 1, s, f);
                    ipChannel[nIndex[c] - 1] = stack.getProcessor(n1);
                    ipLabel[nIndex[c] - 1] = stack.getSliceLabel(n1);
                }
                for (int c = 0; c < nChannel; c++) {
                    n1 = imp.getStackIndex(c + 1, s, f);
                    stack.setProcessor(ipChannel[c], n1);
                    stack.setSliceLabel(ipLabel[c], n1);
                }
            }
        }

        imp.setStack(stack);

        imp.updateAndDraw();
//        imp.updateAndRepaintWindow();
//        imp. 	updateImage();
    }
}
