
import com.ducret.resultJ.ImPlus;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.io.Opener;
import ij.plugin.filter.PlugInFilter;
import ij.gui.GenericDialog;
import static ij.plugin.filter.PlugInFilter.DOES_16;
import static ij.plugin.filter.PlugInFilter.DOES_32;
import static ij.plugin.filter.PlugInFilter.DOES_RGB;
import ij.process.ImageProcessor;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;

public class ColorConverter_ implements PlugInFilter {

    ImagePlus imp;

    @Override
    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return DOES_RGB;
    }

    @Override
    public void run(ImageProcessor ip) {

        ImageStack input = imp.getImageStack();

        GenericDialog gd = new GenericDialog("Color Converter");

        gd.addStringField("Target color:", (String) Prefs.get("MicrobeJ.ColorConverter.target", "255,255,255"), 15);
        gd.addStringField("Dest color:", (String) Prefs.get("MicrobeJ.ColorConverter.dest", "255,255,255"), 15);

        gd.showDialog();

        if (gd.wasCanceled()) {
            return;
        }

        String sTarget = gd.getNextString();
        String sDest = gd.getNextString();

        Prefs.get("MicrobeJ.ColorConverter.target", sTarget);
        Prefs.get("MicrobeJ.ColorConverter.dest", sDest);

        Color cTarget = getColor(sTarget);
        Color cDest = getColor(sDest);

        ImPlus.ConvertColor(imp, cTarget, cDest);

    }

    public static Color getColor(String input) {
        if (input != null) {
            String[] c = input.split(",");
            if (c.length >= 3 && !c[0].isEmpty() && !c[1].isEmpty() && !c[2].isEmpty()) {
                int r = Integer.parseInt(c[0]);
                int g = Integer.parseInt(c[1]);
                int b = Integer.parseInt(c[2]);
                int a = c.length >= 4 ? Integer.parseInt(c[3]) : 255;
                return new Color(r, g, b, a);
            }
        }
        return null;
    }

}
