
import ij.*;
import ij.process.*;
import ij.gui.*;
import ij.io.*;
//import java.awt.*;
import java.awt.Rectangle;
import ij.plugin.*;
import ij.plugin.filter.*;
import ij.plugin.frame.*;
import com.ducret.resultJ.*;

//import
public class Duplicate_ implements PlugInFilter {

    ImagePlus imp;
    String title;
    boolean stack, dStack;
    String channel, frame, slice;

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        channel = "";
        frame = "";
        slice = "";
        dStack = false;

        return DOES_8G + DOES_16 + DOES_32 + DOES_RGB;
    }

    public void run(ImageProcessor ip) {

        //imp.unlock();
        Roi activeRoi = imp.getRoi();
        title = imp.getTitle() + "_1";
        int[] dimension = imp.getDimensions();
        int nbDimension = imp.getNDimensions();

        channel = "1-" + dimension[2];
        slice = "1-" + dimension[3];
        frame = "1-" + dimension[4];

        stack = nbDimension > 2;
        ImagePlus imp2;
        if (stack) {
            dStack = true;
            if (!getUserParameters()) {
                return;
            }
        }
        if (dStack) {
            String[] ch = Range.toRange(channel);
            String[] sl = Range.toRange(slice);
            String[] fr = Range.toRange(frame);
            imp2 = (new Duplicator()).run(imp, Integer.parseInt(ch[0]), Integer.parseInt(ch[1]), Integer.parseInt(sl[0]), Integer.parseInt(sl[1]), Integer.parseInt(fr[0]), Integer.parseInt(fr[1]));
            imp2.setTitle(title);
        } else {
            ImageProcessor ip2 = imp.getProcessor().duplicate();
            ip2.setRoi(activeRoi);
            ip2 = ip2.crop();
            imp2 = new ImagePlus(title, ip2);
        }
        int[] dimension2 = imp2.getDimensions();
        int nbDimension2 = imp2.getNDimensions();
        //boolean frame = imp.getNDimensions() > 2;
        Overlay overlay2 = new Overlay();
        if (activeRoi == null) {
            for (Roi r : imp.getOverlay().toArray()) {
                overlay2.addElement((Roi) r.clone());
            }
        } else {
            Rectangle bounds = activeRoi.getBounds();
            Roi r2;
            int p, c, s, f;

            for (Roi r : imp.getOverlay().toArray()) {
                if (r != null && DoublePolygon.overlaps(bounds, r.getBounds())) {
                    p = r.getPosition();
                    c = r.getCPosition();
                    s = r.getZPosition();
                    f = r.getTPosition();
                    r2 = ListOfRoi.getRoi(r, -bounds.x, -bounds.y, 1);

                    
                    c = (dimension2[2]>1)?c:0;
                    s = (dimension2[3]>1)?s:0;
                    f = (dimension2[4]>1)?f:0;
                    
                    if (nbDimension2 == 3) {
                       if(dimension2[2]>1){
                           r2.setPosition(0);
                       }else{
                           r2.setPosition(Math.max(s, f));
                       }
                    } else {
                        r2.setPosition(c,s,f);
                    }

                    
                    //r2.setPosition(p);
                    overlay2.addElement(r2);
                }
            }
        }
        imp2.setOverlay(overlay2);
        imp2.show();
    }

    private boolean getUserParameters() {
        GenericDialog gd = new GenericDialog("Duplicate");
        gd.addStringField("Title: ", title);

        gd.addCheckbox("duplicate stack", dStack);
        if (!channel.equals("1-1")) {
            gd.addStringField("Channels (c): ", channel);
        }
        if (!frame.equals("1-1")) {
            gd.addStringField("Frames (t): ", frame);
        }
        if (!slice.equals("1-1")) {
            gd.addStringField("Slice (z): ", slice);
        }

        gd.showDialog();

        if (gd.wasCanceled()) {
            return false;
        }

        title = gd.getNextString();
        dStack = gd.getNextBoolean();
        if (!channel.equals("1-1")) {
            channel = gd.getNextString();
        }
        if (!frame.equals("1-1")) {
            frame = gd.getNextString();
        }
        if (!slice.equals("1-1")) {
            slice = gd.getNextString();
        }

        return true;
    }
}
