
import ij.*;
import ij.process.*;
import ij.gui.*;
import java.awt.Color;
import ij.plugin.filter.*;
import com.ducret.resultJ.*;
import java.awt.BasicStroke;

//import
public class FlattenRoi_ implements PlugInFilter {

    ImagePlus imp;
    int resolutionFactor;
    int thickness;
    //boolean getCopy = false;
    //boolean blackAndWhite = false;
    int background;
    int color;
    int composite;

    private final static String[] bMode = {"Image", "White", "Black"};
    private final static String[] cMode = {"Original", "Black", "White", "none"};
    private final static String[] oMode = {"Auto", "Composite", "Color"};

    private final static Color BLACK = new Color(0, 0, 0);
    private final static Color WHITE = new Color(255, 255, 255);

    @Override
    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return DOES_8G + DOES_16 + DOES_32 + DOES_RGB;
    }

    @Override
    public void run(ImageProcessor ip) {

        resolutionFactor = (int) Prefs.get("MicrobeJ.flattenRoi.resolution", 4);
        thickness = (int) Prefs.get("MicrobeJ.flattenRoi.thickness", 1);
        background = (int) Prefs.get("MicrobeJ.flattenRoi.background", 0);
        color = (int) Prefs.get("MicrobeJ.flattenRoi.color", 0);
        composite = (int) Prefs.get("MicrobeJ.flattenRoi.composite", 0);

        if (!getUserParameters()) {
            return;
        }

        Prefs.set("MicrobeJ.flattenRoi.resolution", resolutionFactor);
        Prefs.set("MicrobeJ.flattenRoi.thickness", thickness);
        Prefs.set("MicrobeJ.flattenRoi.background", background);
        Prefs.set("MicrobeJ.flattenRoi.color", color);
        Prefs.set("MicrobeJ.flattenRoi.composite", composite);

        boolean c = imp.isComposite() && (composite == 1 || (composite == 0 && ((CompositeImage) imp).getMode() == CompositeImage.COMPOSITE));
        ImagePlus[] imp1 = ImPlus.getFlattenImage(imp, resolutionFactor, thickness, background, color, c);
        for (ImagePlus i : imp1) {
            if (i != null) {
                i.show();
            }
        }
    }

    private boolean getUserParameters() {
        GenericDialog gd = new GenericDialog("Flatten Roi");
        gd.addNumericField("Resolution: ", resolutionFactor, 0);
        gd.addNumericField("Thickness: ", thickness, 0);
        gd.addChoice("Background:", bMode, bMode[background]);
        gd.addChoice("Colors:", cMode, cMode[color]);

        if (imp.isComposite()) {
            gd.addChoice("Output:", oMode, oMode[composite]);
        }

        //gd.addCheckbox("", getCopy);
        gd.showDialog();

        if (gd.wasCanceled()) {
            return false;
        }

        resolutionFactor = (int) gd.getNextNumber();
        thickness = (int) gd.getNextNumber();
        background = gd.getNextChoiceIndex();
        color = gd.getNextChoiceIndex();
        if (imp.isComposite()) {
            composite = gd.getNextChoiceIndex();
        }
        //getCopy = gd.getNextBoolean();
        return true;
    }
    /*
    public static Roi getRoi(Roi r, double deltaX, double deltaY, int factor) {
        Roi r1 = null;
        switch (r.getType()) {
            case 0: //Rectangle
                if (r instanceof TextRoi) {
                    Rectangle2D.Double bounds1 = r.getFloatBounds();
                    TextRoi t = (TextRoi) r;
                    Font font1 = t.getCurrentFont();
                    Font font2 = new Font(font1.getName(), font1.getStyle(), font1.getSize() * factor * 2);
                    r1 = new TextRoi((bounds1.x+deltaX) * factor, (bounds1.y+deltaY) * factor, t.getText(), font2);
                    //IJ.log(">" + r + " : " + r.getType());
                } else {
                    Rectangle2D.Double bounds0 = r.getFloatBounds();
                    r1 = new Roi(((bounds0.x+deltaX) * factor), ((bounds0.y+deltaY) * factor), bounds0.width * factor, bounds0.height * factor);
                }
                break;
            case 1: //Oval
                Rectangle2D.Double bounds1 = r.getFloatBounds();
                FloatPolygon p1 = r.getFloatPolygon();
                r1 = new OvalRoi((((p1.xpoints[0]+deltaX) + (bounds1.width / 2)) * factor) - (bounds1.width * factor / 2), (((p1.ypoints[0]+deltaY) + (bounds1.height / 2)) * factor) - (bounds1.height * factor / 2), (bounds1.width * factor), (bounds1.height * factor));
                break;
            case 4: //TRACED_ROI
            case 2: //Polygon
                r1 = new PolygonRoi(getPolygonWithFactor(r.getFloatPolygon(), deltaX,deltaY,factor), Roi.POLYGON);
                break;
            case 6: //PolyLine
                r1 = new PolygonRoi(getPolygonWithFactor(r.getFloatPolygon(), deltaX,deltaY,factor), Roi.POLYLINE);
                break;
            case 5: //Line
                if (r instanceof Line) {
                    FloatPolygon d = getPolygonWithFactor(((Line) r).getFloatPoints(), deltaX,deltaY,factor);
                    if (d.npoints > 1) {
                        r1 = new Line(d.xpoints[0], d.ypoints[0], d.xpoints[1], d.ypoints[1]);
                    }
                }
                break;
            default:
                r1 = (Roi) r.clone();
                break;
        }
        
        if(r1!=null){
            r1.setStrokeColor(r.getStrokeColor());
            r1.setStrokeWidth(r.getStrokeWidth());
            r1.setPosition(r.getPosition());
            r1.setTPosition(r.getTPosition());
            r1.setZPosition(r.getZPosition()) ;
        }
        return r1;
    }

    public static FloatPolygon getPolygonWithFactor(FloatPolygon p1, double deltaX, double deltaY, double factor) {
        FloatPolygon p2 = new FloatPolygon();
        for (int j = 0; j < p1.npoints; j++) {
            p2.addPoint((p1.xpoints[j] + deltaX) * factor, (p1.ypoints[j] + deltaY) * factor);
        }
        return p2;
    }*/
}
