
import com.ducret.resultJ.ImPlus;
import com.ducret.resultJ.RJ;
import com.ducret.resultJ.StringFilter;
import ij.ImagePlus;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.io.FileSaver;
import ij.plugin.PlugIn;
import java.io.File;
import java.util.ArrayList;

public class FolderMerger_ implements PlugIn {

    @Override
    public void run(String arg) {

        String folder = Prefs.get("MicrobeJ.folderMerger.folder", "");
        String folderFilter = Prefs.get("MicrobeJ.folderMerger.folder_filter", "");
        boolean folderRecursive = Prefs.get("MicrobeJ.folderMerger.folder_recursive", false);
//        boolean override = Prefs.get("MicrobeJ.folderMerger.override", false);

        GenericDialog gd = new GenericDialog("FolderMerger");

        gd.addDirectoryField("Folder:", folder);
        gd.addStringField("Filter:", folderFilter);
        gd.addCheckbox("Recursive", folderRecursive);
//        gd.addCheckbox("override", override);

        gd.showDialog();

        if (!gd.wasCanceled()) {

            folder = gd.getNextString();
            folderFilter = gd.getNextString();
            folderRecursive = gd.getNextBoolean();
//            override = gd.getNextBoolean();

            Prefs.set("MicrobeJ.folderMerger.folder", folder);
            Prefs.set("MicrobeJ.folderMerger.folder_filter", folderFilter);
            Prefs.set("MicrobeJ.folderMerger.folder_recursive", folderRecursive);
//            Prefs.set("MicrobeJ.folderMerger.override", override);

            ArrayList<File> dir = ImPlus.getImagesContainingDirectories(folder, folderFilter, folderRecursive);
            String directory;
            FileSaver fSaver;
            for (File d : dir) {
                ArrayList<File> iFile = ImPlus.getImagesFiles(d.getAbsolutePath(), new StringFilter(folderFilter));
                RJ.l("" + d.getPath().replace(folder,"") + " : " + iFile.size() + " image(s) found");
                ImagePlus[] imgs = ImPlus.getImages(iFile.toArray(new File[0]), null);

                directory = d.getParent();
                directory += (directory.endsWith(File.separator)) ? "" : File.separator;

                String name;//

                int j = 1;
                for (ImagePlus im : imgs) {
                    if (im != null) {
                        name = (imgs.length > 1) ? d.getName() + "_" + j++ : d.getName();
                        fSaver = new FileSaver(im);
                        fSaver.saveAsTiff(directory + name + ".tif");
                        im.close();
                    }
                }
                RJ.clearMemory();
            }

        }

    }

}
