// This macro converts a 16x16 8-bit image to a tool macro icon
// string. Ideally, the image should have no more than 16 colors.
// Includes seven examples that, with the exception of the 
// "Lena Tool", were created by converting website favicons
// (http://en.wikipedia.org/wiki/Favicon).

macro "Convert Image to Tool Icon..." {
  requires("1.35r");
  if (bitDepth!=8 || getWidth>16 || getHeight>16)
     exit("This macro requires 16x16 8-bit image");
  Dialog.create("Image 2 Tool");
  Dialog.addString("Tool name", "myTool");
  Dialog.addCheckbox("Transparent Color", true);
  Dialog.addNumber("Value", 0);
  Dialog.show();
  mytool = Dialog.getString();
  allPixels = !Dialog.getCheckbox();
  transparent = Dialog.getNumber();
  getLut(r,g,b);
  getRawStatistics(area, mean, min, max);
  ts='macro "'+mytool+' Tool - ';
  for (i=0; i<=max; i++) {
      if (allPixels || i!=transparent) {
          r2=floor(r[i]/256*16);
          g2=floor(g[i]/256*16);
          b2=floor(b[i]/256*16);
          color = "C"+toHex(r2)+toHex(g2)+toHex(b2);
          if (!endsWith(ts, color)) ts=ts+color;
          for (x=0; x<getWidth; x++) {
              for (y=0; y<getHeight; y++) {
                  if (getPixel(x,y)==i)
                      ts=ts+"D"+toHex(x)+toHex(y);
              }
          }
      }
  }
  ts=ts+'"{\n\n}';
  macrodir = getDirectory("macros");
  if (!endsWith(mytool,".txt")) mytool = mytool+".txt";
  f = File.open(macrodir+mytool);
  print (f, ts);
  File.close(f);
  open(macrodir+mytool);
}