
import ij.*;
import ij.plugin.*;
import com.ducret.microbeJ.*;
import com.ducret.resultJ.ImPlus;
import com.ducret.resultJ.Property;
import com.ducret.resultJ.Result;
import com.ducret.resultJ.Template;
import java.io.File;

public class MicrobeJ_m implements PlugIn {

    public final String[] TAGS = {"settings", "output", "image", "name", "debug", "mask"};

    @Override
    public void run(String arg) {
        String options = Macro.getOptions();//"output=C:\\Users\\aducret\\Desktop\\test\\  ";// settings=C:\\Users\\aducret\\Desktop\\pneumo2.xml  name= image=C:\\Users\\aducret\\Desktop\\4-FtsA-mKate.tif 
        String[] aOptions = (options == null) ? new String[0] : options.split(" ");

        String[] arguments = new String[TAGS.length];
        for (String o : aOptions) {
            for (int i = 0; i < TAGS.length; i++) {
                if (o.startsWith(TAGS[i])) {
                    arguments[i] = o.substring(TAGS[i].length() + 1);
                    //RJ.l(TAGS[i] + ">" + arguments[i]);
                }
            }
        }
        boolean debug = "on".equals(arguments[4]);

        File sFile = (arguments[0] != null && !arguments[0].isEmpty()) ? new File(arguments[0]) : null;

        Property settings = (sFile != null && sFile.exists()) ? Property.load(arguments[0]) : Property.load(MJ.INI_PATH);

        ImPlus image;
        ImPlus mask;
        File iFile = null;

        //Image
        if (arguments[2] != null && !arguments[2].isEmpty()) {
            iFile = new File(arguments[2]);
            ImagePlus imp = ImPlus.loadImagePlus(arguments[2]);
            image = new ImPlus(imp);
        } else {
            image = ImPlus.getCurrentImPlus();
        }

        if (arguments[5] != null && !arguments[5].isEmpty()) {
            ImagePlus iMask = ImPlus.loadImagePlus(arguments[5]);
            mask = new ImPlus(iMask);
            settings.set("THRESHOLD",ImMask.MASK_MODE_USER);
            if (image != null) {
                image.setMask(mask);
            }
        }

        if (debug) {
            if (image != null) {
                image.show();
            }
            //settings.show();
        }
        settings.setImage(image);

        String eName = (arguments[3] != null && !arguments[3].isEmpty()) ? arguments[3] : "Experiment";

        Experiment exp = new Experiment(eName, settings);
        exp.run(image);

        if (MJ.escapePressed() || exp.isError()) {
            return;
        }

        //
        Result r = exp.getResult();
        if (r != null) {
            if (debug) {
                r.show();
            }
            boolean tActive = settings.getB("TEMPLATE", false);

            String rPath = arguments[1];

            if ((rPath == null || rPath.isEmpty()) && iFile != null) {
                if (iFile.isDirectory()) {
                    rPath = iFile.getAbsolutePath();
                } else {
                    String n = iFile.getName();
                    int i = n.lastIndexOf('.');
                    rPath = iFile.getParent() + File.separator + n.substring(0, i) + File.separator;
                }
            }

            if (rPath != null && !rPath.isEmpty()) {
                r.saveToCsv(rPath);
                if (tActive) {
                    Template t = (Template) settings.get("RESULT_TEMPLATE");
                    if (t != null) {
                        t.setPath(rPath);
                        t.savePanels(rPath, "", r);

                    }
                }
            } else if (tActive) {
                exp.show(Experiment.OUTPUT_TEMPLATE, r);
            }
        }
        MJ.clearMemory(0.7);
    }
}
