
import ij.*;
import ij.process.*;
import ij.gui.*;
import ij.plugin.*;
import com.ducret.resultJ.*;
import com.ducret.microbeJ.*;

public class MicrobeJ_r implements PlugIn {

    public void run(String arg) {
        String filePath = arg.length() > 0 ? arg : MJ.INI_PATH;
        Property parameters = Property.load(filePath);
        ImPlus image = ImPlus.getCurrentImPlus();
        parameters.setImage(image);
        int mode = parameters.getI("RUN_MODE", 6);

        if (mode == 9) {
            MicrobeJ.runOnActiveImPlus("", parameters);
        } else {
            Experiment exp = new Experiment("Experiment", parameters);
            exp.run();
            exp.show(mode);
        }

    }
}
