
import ij.*;
import ij.io.OpenDialog;
import ij.plugin.*;
import java.io.*;
import com.ducret.microbeJ.*;
import com.ducret.resultJ.*;

public class MicrobeJ_reader implements PlugIn {

    /**
     * Expects path as argument, or will ask for it and then open the image.
     */
    public void run(final String arg) {
        String path = arg;
        String directory;
        String filename;
        if (null == path || 0 == path.length()) {
            OpenDialog od = new OpenDialog("Choose File", null);
            directory = od.getDirectory();
            if (null == directory) {
                return;
            }
            filename = od.getFileName();
            path = directory.endsWith(File.separator) ? directory + filename : directory + File.separator + filename;
        } else {
            // the argument is the path
            File file = new File(path);
            directory = file.getParent(); // could be a URL
            filename = file.getName();
            if (directory.startsWith("http:/")) {
                directory = "http://" + directory.substring(6); // the double '//' has been eliminated by the File object call to getParent()
            }
        }

        if (filename.toLowerCase().endsWith(".res")) {
            IJ.showStatus("Loading Result: " + path);
            Result result1 = Result.load(path);
            if (result1 != null) {
                result1.show();//result1.open();
            }
            IJ.showStatus("done");
        } else if (filename.toLowerCase().endsWith(".ini") || filename.toLowerCase().endsWith(".xml")) {
            MicrobeJ microbeJ = MJ.getMicrobeJInstance();
            microbeJ.setParameters(filename);
            microbeJ.setVisible(true);
        } else if (filename.toLowerCase().endsWith(".exp")) {
            Experiment exp1 = Experiment.load(path);
            if (exp1 != null) {
                exp1.edit();
            }
        }
    }
}
