
import com.ducret.resultJ.Geometry;
import com.ducret.resultJ.Range;
import ij.*;
import ij.gui.GenericDialog;
import ij.process.*;
import ij.plugin.filter.*;
import ij.process.Blitter;
import java.util.ArrayList;
import com.ducret.resultJ.ImPlus;
import ij.gui.Roi;
import ij.gui.TextRoi;
import java.awt.Color;
import java.awt.Rectangle;
//import

public class MontageStack_ implements PlugInFilter {

    ImagePlus imp;

    @Override
    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return DOES_RGB + DOES_8G + DOES_16 + DOES_32 + STACK_REQUIRED;
    }

    public void run(ImageProcessor ip) {

        ImagePlus[] imgs = ImPlus.getOpenedImagePlus();

        ArrayList<ImageStack> stacks = new ArrayList<ImageStack>();
        Range width = new Range();
        Range height = new Range();
        Range slice = new Range();

        ImageStack stack;
        for (ImagePlus i : imgs) {
            stack = i.getImageStack();
            if (stack.getSize() > 1) {
                stacks.add(stack);
                width.update(stack.getWidth());
                height.update(stack.getHeight());
                slice.update(stack.getSize());
            }
        }

        //RJ.l(">" + width + " : " + height + " / " + slice);
        int cols = (int) Prefs.get("MicrobeJ.montageStack.cols", stacks.size());
        int rows = (int) Prefs.get("MicrobeJ.montageStack.rows", 1);
        String slices = (String) Prefs.get("MicrobeJ.montageStack.slices", "1-" + ((int) slice.max));
        String label = (String) Prefs.get("MicrobeJ.montageStack.label", "");
        String labelWidth = (String) Prefs.get("MicrobeJ.montageStack.labelWidth", "auto");

        GenericDialog gd = new GenericDialog("Montage Stack");

        gd.addNumericField("Columns", cols, 0);
        gd.addNumericField("Rows", rows, 0);
        gd.addStringField("Slices", slices);
        gd.addStringField("Label", label);
        gd.addStringField("Label Width", labelWidth);

        gd.showDialog();
        if (!gd.wasCanceled()) {

            cols = (int) gd.getNextNumber();
            rows = (int) gd.getNextNumber();
            slices = gd.getNextString();
            label = gd.getNextString();
            labelWidth = gd.getNextString();

            Prefs.set("MicrobeJ.montageStack.cols", cols);
            Prefs.set("MicrobeJ.montageStack.rows", rows);
            Prefs.set("MicrobeJ.montageStack.slices", slices);
            Prefs.set("MicrobeJ.montageStack.label", label);
            Prefs.set("MicrobeJ.montageStack.labelWidth", labelWidth);

            Range slice2 = new Range(slices);

            slice2.max = Math.min(slice2.max, slice.max);

            Roi labelRoi = null;
            Rectangle labelBound;
            if (label != null && label.length() > 0) {
                labelRoi = new TextRoi(0, 0, label, new java.awt.Font("Tahoma", 0, 20));
                labelBound = labelRoi.getBounds();
                if (!"auto".equals(labelWidth)) {
                    labelBound.width = Integer.parseInt(labelWidth);
                }

            } else {
                labelBound = new Rectangle(0, 0, 0, 0);
            }

            int c, r, t;
            c = 0;
            r = 0;
            t = 0;

            int[][] aWidth = new int[cols][rows];
            int[][] aHeight = new int[rows][cols];
            for (ImageStack s : stacks) {
                if (s != null) {
                    aWidth[c][r] = s.getWidth();
                    aHeight[r][c] = s.getHeight();
                    c++;
                    if (c >= cols) {
                        r++;
                        c = 0;
                    }
                }
            }
            int[] xloc = new int[cols + 1];
            int[] yloc = new int[rows + 1];

            int wMax = 0;
            xloc[0] = (int) (labelBound.width * 1.2);
            for (int i = 1; i <= cols; i++) {
                xloc[i] = xloc[i - 1] + Geometry.max(aWidth[i - 1]);
                wMax = xloc[i];
            }
            int hMax = 0;
            for (int i = 1; i <= rows; i++) {
                yloc[i] = yloc[i - 1] + Geometry.max(aHeight[i - 1]);
                hMax = yloc[i];
            }

            if (labelRoi != null) {
                labelRoi.setLocation((int) (xloc[0] / 2) - (labelBound.width / 2), (int) (hMax / 2) - (labelBound.height / 2));
            }

            ImageStack output = new ImageStack(wMax, hMax);
            ImageProcessor ipTemp, ipStack;
            for (int p = (int) slice2.min; p <= slice2.max; p++) {
                IJ.showStatus("Montage :" + p + "/" + slice2.max);
                c = 0;
                r = 0;
                t = 0;
                ipTemp = ip.createProcessor(wMax, hMax);

                if (labelRoi != null) {
                    ipTemp.setColor(Color.WHITE);
                    labelRoi.drawPixels(ipTemp);
                }

                for (ImageStack s : stacks) {
                    if (p >= 1 && p <= s.getSize()) {
                        ipStack = s.getProcessor(p);
                        ipTemp.copyBits(ipStack, xloc[c], yloc[r], Blitter.ADD);
                        t++;
                    }
                    c++;
                    if (c >= cols) {
                        r++;
                        c = 0;
                    }
                }
                if (t > 0) {
                    output.addSlice(ipTemp);
                }
            }
            ImagePlus imp2 = new ImagePlus("", output);
            //imp2.setRoi(labelRoi);
            imp2.show();

        }

    }

}
