
import com.ducret.microbeJ.ImMask;
import com.ducret.microbeJ.Parameter;
import ij.plugin.*;
import com.ducret.resultJ.ImPlus;
import com.ducret.resultJ.ImPosition;
import com.ducret.resultJ.RJ;
import ij.IJ;
import ij.ImagePlus;
import ij.ImageStack;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.process.ImageProcessor;
import java.io.File;
import com.ducret.resultJ.Property;
import ij.process.FloatProcessor;

public class SimpleBatch_ implements PlugIn {

    @Override
    public void run(String arg) {

        //String mExtension = "_m";
        String settings = Prefs.get("MicrobeJ.simpleBatch.settings", "");
        String folder = Prefs.get("MicrobeJ.simpleBatch.folder", "");
        boolean recursive = Prefs.get("MicrobeJ.simpleBatch.recursive", false);
        String maskFilter = Prefs.get("MicrobeJ.simpleBatch.maskFilter", "_m");

        GenericDialog gd = new GenericDialog("Simple Batch");

        gd.addFileField("Settings:", settings);
        gd.addDirectoryField("Folder:", folder);
        gd.addStringField("Mask Filter:", maskFilter);
        gd.addCheckbox("Recursive", recursive);

        gd.showDialog();

        if (!gd.wasCanceled()) {

            settings = gd.getNextString();
            folder = gd.getNextString();
            maskFilter = gd.getNextString();
            recursive = gd.getNextBoolean();

            Prefs.set("MicrobeJ.simpleBatch.settings", settings);
            Prefs.set("MicrobeJ.simpleBatch.folder", folder);
            Prefs.set("MicrobeJ.simpleBatch.maskFilter", maskFilter);
            Prefs.set("MicrobeJ.simpleBatch.recursive", recursive);

            Property p1 = new Property(new File(settings));
//            Parameter p = new Parameter(p1.getP("bacteria"));

            File parent = new File(folder);
            if (parent.exists() && parent.isDirectory()) {
                File[] images = ImPlus.getImageFiles(parent, recursive);
                
                for (File i : images) {
                    
                }
                
                
                
                for (File i : images) {
                    String name;
                    String nMask;
                    ImagePlus imp;
                    ImagePlus mask;
                    File fMask;
                    if (i.exists() && i.isFile()) {
                        name = RJ.removeExtension(i.getName());
                        if (!name.endsWith(suffix)) {
                            RJ.l(">" + name);
                            nMask = name + suffix;
                            fMask = new File(IJ.addSeparator(i.getParent()) + nMask + ".tif");
                            if (override || !fMask.exists()) {
                                imp = ImPlus.loadImagePlus(i.getPath());
                                mask = getMask(imp, p);
                                mask.setTitle(nMask);
                                RJ.l("->" + nMask);
                                IJ.saveAsTiff(mask, fMask.getPath());
                            }
                        }
                    }
                }
            }
        }
    }

    
}
