
import com.ducret.resultJ.DoublePolygon;
import com.ducret.resultJ.FloatPoint;
import com.ducret.resultJ.RJ;
import ij.Prefs;
import ij.gui.GenericDialog;
import ij.gui.Roi;
import ij.measure.ResultsTable;
import ij.plugin.PlugIn;
import ij.plugin.frame.RoiManager;

public class SlopeExtractor_ implements PlugIn {

    public void run(String arg) {

        double scaling = (double) Prefs.get("MicrobeJ.slopeExtractor.scaling", 15.4536);
        double interval = (double) Prefs.get("MicrobeJ.slopeExtractor.interval", 1);

        GenericDialog gd = new GenericDialog("KymoGraph");
        gd.addNumericField("Scaling[m]:", scaling, 4);
        gd.addNumericField("Interval[s]:", interval, 4);

        gd.showDialog();
        if (!gd.wasCanceled()) {

            
            scaling= gd.getNextNumber();
            interval= gd.getNextNumber();
            
            DoublePolygon p;
            FloatPoint s, e;
            double slope;
            double d,t;
            ResultsTable rTable = new ResultsTable();
            RoiManager manager = RoiManager.getInstance();
            if (manager != null) {
                int i = 0;
                for (Roi r : manager.getRoisAsArray()) {
                    p = new DoublePolygon(r);
                    s = p.getFirst();
                    e = p.getLast();
                    if (s != null && e != null) {
                        d = (s.y - e.y) / scaling;
                        t = (s.x - e.x) * interval;
                        slope = d / t;
                        rTable.incrementCounter();
                        rTable.addLabel(Integer.toString(i++));
                        rTable.addValue("slope", slope);
                        rTable.addValue("abs(slope)", Math.abs(slope));
                        //RJ.l(">" + s + " / " + e);
                    }
                }
            }
            rTable.show("Slope");
        }
    }
}
