
import ij.*;
import ij.process.*;
import ij.gui.*;
import ij.plugin.*;
import ij.plugin.filter.*;

//import
public class T_Project implements PlugInFilter {
    
    ImagePlus imp;
    int method;
    int mode;
    int size;
    public static final String[] METHODS = {"Average Intensity", "Max Intensity", "Min Intensity", "Sum Slices", "Standard Deviation", "Median"};
    public static final String[] MODES = {"Simple", "Progressive","Moving window"};
    
    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return DOES_ALL;
    }
    
    public void run(ImageProcessor ip) {
        
        if (!getUserParameters()) {
            return;
        }
        boolean isHyperstack = imp.isHyperStack();
        
        if (!isHyperstack) {
            
            ImageStack stack1 = imp.getStack();
            int nbSlice = stack1.getSize();
            ImageProcessor[] stack2 = new ImageProcessor[nbSlice];
            
            ZProjector projector = new ZProjector(imp);
            projector.setMethod(method);
            
            ImagePlus imp2;
            ImageProcessor ip2;
            switch (mode) {
                case 0:
                    if (isHyperstack) {
                        //projector.doHyperStackProjection((imp.getNFrames() > 1 && imp.getNSlices() > 1));
                    } else if (imp.getType() == ImagePlus.COLOR_RGB) {
                        projector.doRGBProjection();
                    } else {
                        projector.doProjection();
                    }
                    imp2 = projector.getProjection();
                    ip2 = imp2.getProcessor();
                    for (int i = 0; i < nbSlice; i++) {
                        stack2[i] = ip2.duplicate();
                    }
                    imp2.flush();
                    break;
                case 1:
                    projector.setStartSlice(1);
                    for (int i = 0; i < nbSlice; i++) {
                        projector.setStopSlice(i + 1);
                        if (isHyperstack) {
                            //projector.doHyperStackProjection((imp.getNFrames() > 1 && imp.getNSlices() > 1));
                        } else if (imp.getType() == ImagePlus.COLOR_RGB) {
                            projector.doRGBProjection();
                        } else {
                            projector.doProjection();
                        }
                        imp2 = projector.getProjection();
                        ip2 = imp2.getProcessor();
                        stack2[i] = ip2.duplicate();
                    }
                    break;
                case 2:
                    int sSlice;
                    for (int i = 0; i < nbSlice; i++) {
                        sSlice = (i - size) >= 0 ? (i - size) : 0;
                        projector.setStartSlice(sSlice + 1);
                        projector.setStopSlice(i + 1);
                        
                        //RJ.l(i + " : " + (sSlice) + " / " + i);
                        if (isHyperstack) {
                            //projector.doHyperStackProjection((imp.getNFrames() > 1 && imp.getNSlices() > 1));
                        } else if (imp.getType() == ImagePlus.COLOR_RGB) {
                            projector.doRGBProjection();
                        } else {
                            projector.doProjection();
                        }
                        imp2 = projector.getProjection();
                        ip2 = imp2.getProcessor();
                        stack2[i] = ip2.duplicate();
                    }
                    
                    break;
            }
            
            String title = imp.getTitle() + "_p";
            
            ImageStack stack3 = new ImageStack(imp.getWidth(), imp.getHeight());
            for (int i = 0; i < nbSlice; i++) {
                stack3.addSlice(stack2[i]);
            }
            
            ImagePlus imp3 = imp.createImagePlus();
            imp3.setStack(title, stack3);
            imp3.show();
        }
        
    }
    
    private boolean getUserParameters() {
        
        GenericDialog gd = new GenericDialog("Time Projection");
        gd.addChoice("Type", METHODS, METHODS[method]);
        gd.addChoice("Mode", MODES, MODES[mode]);
        gd.addNumericField("Size:", 2, 0);
        gd.showDialog();
        
        if (gd.wasCanceled()) {
            return false;
        }
        method = (int) gd.getNextChoiceIndex();
        mode = (int) gd.getNextChoiceIndex();
        size = (int) gd.getNextNumber();
        return true;
    }
    
}
