import ij.*;
import ij.process.*;
import ij.gui.*;
import ij.plugin.*;
import ij.plugin.filter.*;

//import
public class T_Project_s2 implements PlugInFilter {

    ImagePlus imp;

    public static final String[] METHODS = {"Average Intensity", "Max Intensity", "Min Intensity", "Sum Slices", "Standard Deviation", "Median"};

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return DOES_ALL;
    }

    public void run(ImageProcessor ip) {

        //on defini une methode par d"faut
        int method = 0;
        //On declare une nouvelle boite de dialogue
        GenericDialog gd = new GenericDialog("Time Projection");
        //On ajoute un champ 'choix' pour permettre la selection de la methode
        gd.addChoice("Methode", METHODS, METHODS[method]);
        //On affiche la boite de dialogue
        gd.showDialog();
        
        
        //Si l'utilisateur clique sur 'Cancel' alors on ne fait rien (return)
        if (gd.wasCanceled()) {
            return;
        }
        //Sinon on recupere la methode choisie
        method = (int) gd.getNextChoiceIndex();
       
        //On recupere le stack contenu dans l'image de depart
        ImageStack stack_source = imp.getStack();
        //On cre un nouveau stack qui presente les mmes dimensions que le stack source
        ImageStack stack_target = new ImageStack(imp.getWidth(), imp.getHeight());

        //On declare l'outil ZProjector et on lui defini la methode a utiliser et la slice de dpart
        ZProjector projector = new ZProjector(imp);
        projector.setMethod(method);
        projector.setStartSlice(1);
        
        //On recupere le nombre de Slice dans le stack source
        int nbSlice = stack_source.getSize();
        ImagePlus imp2;
        //Pour chaque slice du stack source
        for (int i = 0; i < nbSlice; i++) {
            //On defini la slice de fin
            projector.setStopSlice(i + 1);
            //On fait la projection
            projector.doProjection();
            //On recupere la projection sous forme d'un ImagePlus
            imp2 = projector.getProjection();
            //On ajoute le processor de l'ImagePlus au stack de destination
            stack_target.addSlice(imp2.getProcessor());
        }
        
        
        //On defini un nouveau titre en ajoutant '_p' au titre de l'image existante
        String title = imp.getTitle() + "_p";
        //on cre une nouvelle Image (ImagePlus) en recuperant les parametres de l'image source
        ImagePlus imp3 = imp.createImagePlus();
        //On lui affecte le nouveau stack
        imp3.setStack(title, stack_target);
        //On affiche la nouvelle image
        imp3.show();

    }
}

