
import ij.*;
import ij.process.*;
import ij.gui.*;
import ij.plugin.filter.*;
import java.io.File;

//import
public class TrailGenerator_ implements PlugInFilter {

    ImagePlus imp;
    private static final String[] modes = new String[]{"transit", "occupation"};

    public int setup(String arg, ImagePlus imp) {
        this.imp = imp;
        return DOES_8G + DOES_16 + DOES_32 + STACK_REQUIRED;
    }

    public void run(ImageProcessor ip) {
        int width = imp.getWidth();
        int height = imp.getHeight();
        String title = imp.getTitle();
        //ImPlus image = new ImPlus(imp);

        ImageStack stack = imp.getImageStack();
        int mode = (int) Prefs.get("MicrobeJ.trailGenerator.mode", 0);
        int filter = (int) Prefs.get("MicrobeJ.trailGenerator.filter", 5);

        GenericDialog gd = new GenericDialog("Trail Generator");

        gd.addChoice("Mode:", modes, modes[mode]);
        gd.addNumericField("Median Filter:", filter, 0);

        gd.showDialog();
        if (!gd.wasCanceled()) {

            mode = gd.getNextChoiceIndex();
            filter = (int) gd.getNextNumber();

            Prefs.set("MicrobeJ.trailGenerator.mode", mode);
            Prefs.set("MicrobeJ.trailGenerator.filter", filter);

            //gd.addNumericField("Line Width:", lineWidth, 0);
            int nbPosition = stack.getSize();

//        ImageProcessor output = new ByteProcessor(width, height);
//        ImageProcessor output2 = new FloatProcessor(width, height);
            float[][] occupation = new float[nbPosition][width * height];
            byte[][] transit = new byte[nbPosition][width * height];

            double v1, v2;
            int c;
            float a, b;
            for (int x = 0; x < width; x++) {
                IJ.showStatus("Analyzing frames ");
                for (int y = 0; y < height; y++) {
                    c = 0;
                    b = 0;
                    for (int z = 0; z < nbPosition; z++) {
                        v1 = (z > 0) ? stack.getVoxel(x, y, z - 1) : 0;
                        v2 = stack.getVoxel(x, y, z);
                        if (v2 > 0) {
                            if (v1 == 0) {
                                c++;
                            }
                            b++;
                        }
                        occupation[z][x + y * width] = b / (float) nbPosition;
                        transit[z][x + y * width] = (byte) c;
                    }
                }
                IJ.showStatus("Analyzing frames "+(100 * (double) (x) / (double) width)+"%");
                IJ.showProgress((double) (x) / (double) width);
            }
            RankFilters rFilter = new RankFilters();

            ImageStack output = new ImageStack(width, height);
            ImageProcessor ipOut;
            for (int z = 0; z < nbPosition; z++) {

                switch (mode) {
                    case 1:
                        ipOut = new FloatProcessor(width, height, occupation[z]);
                        break;
                    default:
                        ipOut = new ByteProcessor(width, height, transit[z]);
                        break;
                }

                if (filter > 0) {
                    IJ.showStatus("Filtering frame " + z + "/" + nbPosition);
                    rFilter.rank(ipOut, filter, RankFilters.MEDIAN);
                }

                output.addSlice(ipOut);
                IJ.showProgress((double) (z) / (double) nbPosition);
            }
            IJ.showStatus("Done");

            //File f = new File(title);
            String fileName = title.substring(1, title.lastIndexOf("."));
            String fileExt = title.substring(title.lastIndexOf("."));

            ImagePlus imp1 = new ImagePlus(fileName + "_" + modes[mode] + fileExt, output);
            imp1.show();
        }
    }
}
